IF  EXISTS (SELECT * FROM SYS.OBJECTS WHERE OBJECT_ID = OBJECT_ID(N'[DBO].[P_COPIA_CUSTO_MEDIO_FILIAIS]') AND TYPE IN (N'P', N'PC'))
	DROP PROCEDURE [DBO].[P_COPIA_CUSTO_MEDIO_FILIAIS] 

GO

CREATE PROCEDURE P_COPIA_CUSTO_MEDIO_FILIAIS ( @ORIGEM INT, @DESTINO INT)
AS

	Set nocount on;

	Print 'Inicio da rotina - ' + Convert(varchar, getdate(),108)
	Print ' Copiando o custo mdio da filial  ' + Convert(varchar, @ORIGEM) + ' para a filial ' + Convert(varchar, @Destino)

/************************************************************************************************************************/	  

	DECLARE @DT_INI_FILIAL DATE;

	SET @DT_INI_FILIAL = (SELECT TOP 1 DT_INI_SISTEMA FROM PRC_FILIAL WHERE CD_FILIAL =@DESTINO)
 
	CREATE TABLE #TMP_CUSTO_PROD (CD_PROD INT, DT_PROC DATE);

/************************************************************************************************************************/	
	Print 'Busca o custo medio origem.. ' + Convert(varchar, getdate(),108)

	INSERT INTO #TMP_CUSTO_PROD
		   SELECT CD_PROD, 
				  MAX(DT_PROC) DT_PROC
		   FROM EST_FECHA_PROC_MOV
		   WHERE CD_EMP = 1
				 AND CD_FILIAL = @ORIGEM
		   GROUP BY CD_PROD;
/************************************************************************************************************************/	
	Print 'Inser o custo medio .. ' + Convert(varchar, getdate(),108)
	INSERT INTO EST_FECHA_PROC_MOV (CD_EMP,CD_FILIAL,CD_PROD,DT_PROC,QT_EST_INI_DIA,VLR_CUSTO_MD_INI,QT_ENT,VLR_ENT,QT_SAI
									,QT_IMP,VLR_CUSTO_MD_NOVO,QT_EST_FINAL,VLR_CUSTO_GER_INI,VLR_CUSTO_GER_NOVO,VLR_DESC_FINAN,VLR_CUSTO_MD_CALC,VLR_AJUSTE
									,DT_CAD,VLR_DEVOLUCAO,QTD_DEVOLUCAO,QT_AJUSTE_MOV,VLR_SALDO_CUSTO,VLR_AJUSTE_CUSTO,VLR_TABELA,VLR_AJUSTE_CUSTO_TRANSF,QT_INI_COM
									,QT_ENT_COM,VLR_ENT_COM,QT_DEV_COM,VLR_DEV_COM,QT_IMP_COM,VLR_IMP_COM,QT_SAI_COM,VLR_SAI_COM,QT_TRANSF_COM
									,VLR_TRANSF_COM,QT_FINAL_COM,QT_INI_FLUT,QT_ENT_FLUT,VLR_ENT_FLUT,QT_DEV_FLUT,VLR_DEV_FLUT,QT_IMP_FLUT,VLR_IMP_FLUT,QT_SAI_FLUT
									,VLR_SAI_FLUT,QT_TRANSF_FLUT,VLR_TRANSF_FLUT,QT_FINAL_FLUT)
	SELECT 
		 CD_EMP
		,@Destino CD_FILIAL
		,A.CD_PROD
		,@DT_INI_FILIAL DT_PROC
		,A.QT_EST_INI_DIA
		,A.VLR_CUSTO_MD_INI
		,A.QT_ENT
		,A.VLR_ENT
		,A.QT_SAI
		,A.QT_IMP
		,A.VLR_CUSTO_MD_NOVO
		,A.QT_EST_FINAL
		,A.VLR_CUSTO_GER_INI
		,A.VLR_CUSTO_GER_NOVO
		,A.VLR_DESC_FINAN
		,A.VLR_CUSTO_MD_CALC
		,A.VLR_AJUSTE
		,GETDATE() DT_CAD
		,A.VLR_DEVOLUCAO
		,A.QTD_DEVOLUCAO
		,A.QT_AJUSTE_MOV
		,A.VLR_SALDO_CUSTO
		,A.VLR_AJUSTE_CUSTO
		,A.VLR_TABELA
		,A.VLR_AJUSTE_CUSTO_TRANSF
		,A.QT_INI_COM
		,A.QT_ENT_COM
		,A.VLR_ENT_COM
		,A.QT_DEV_COM
		,A.VLR_DEV_COM
		,A.QT_IMP_COM
		,A.VLR_IMP_COM
		,A.QT_SAI_COM
		,A.VLR_SAI_COM
		,A.QT_TRANSF_COM
		,A.VLR_TRANSF_COM
		,A.QT_FINAL_COM
		,A.QT_INI_FLUT
		,A.QT_ENT_FLUT
		,A.VLR_ENT_FLUT
		,A.QT_DEV_FLUT
		,A.VLR_DEV_FLUT
		,A.QT_IMP_FLUT
		,A.VLR_IMP_FLUT
		,A.QT_SAI_FLUT
		,A.VLR_SAI_FLUT
		,A.QT_TRANSF_FLUT
		,A.VLR_TRANSF_FLUT
		,A.QT_FINAL_FLUT
	FROM 
		EST_FECHA_PROC_MOV a
		join #TMP_CUSTO_PROD b on
		a.dt_proc = b.dt_proc and
		a.CD_PROD = b.CD_PROD
	WHERE 
		A.CD_EMP=1
		AND A.CD_FILIAL =@ORIGEM

/*********************************************************************************************************************/
	Print 'Inser acerto .. ' + Convert(varchar, getdate(),108)
	INSERT INTO EST_PROD_CPL_ACERTO_CUSTO(CD_CTR,CD_EMP,CD_FILIAL,CD_PROD,VLR_CUSTO_ACERTO,CD_USU,DT_MOV,DT_CAD,TP_AJUSTE,QT_AJUSTE,VLR_AJUSTE_TRANSF)
	SELECT
		 ROW_NUMBER() OVER( ORDER BY CD_EMP) CD_CTR
		,CD_EMP
		, CD_FILIAL
		,CD_PROD
		,A.VLR_CUSTO_MD_NOVO VLR_CUSTO_ACERTO
		,1 CD_USU
		,@DT_INI_FILIAL DT_MOV
		,GETDATE() DT_CAD
		,0 TP_AJUSTE
		,0 QT_AJUSTE
		,0 VLR_AJUSTE_TRANSF
	FROM 
		EST_FECHA_PROC_MOV A
	WHERE
		CD_EMP=1
		AND CD_FILIAL = @DESTINO
		AND DT_PROC = @DT_INI_FILIAL
/*********************************************************************************************************************/
	Print 'Fim da rotina - ' + Convert(varchar, getdate(),108)